#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Add location of OSEHRAHelper to the Python path
import sys
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path
#---------------------------------------------------------------------------

from OSEHRAHelper import PROMPT
from ConnectToVista import ConnectToVista
from InitializeFileman import InitializeFileman
from InitializeDevice import InitializeDevice
from SetupDomain import SetupDomain
from SetupCPRS import SetupCPRS
from AddHolidays import AddHolidays, AddHolidaysByConfig
from StartTaskMan import StartTaskMan
from CreateSystemManager import CreateSystemManager
from AddInstitutions import AddInstitutions, AddInstitutionsByConfig
from AddDivisions import AddDivisions, AddDivisionsByConfig
from AddDoctors import AddDoctors, AddDoctorsByConfig
from AddPatients import AddTestPatients, AddTestPatientsByConfig
from AddClinics import AddClinics, AddClinicsByConfig
from MakeAppointment import MakeAppointment
from VerifyOneAppointment import VerifyOneAppointment
from AddServiceSection import AddServiceSection, AddServiceSectionByConfig
from AddNotificationLetters import AddNotificationLetters, AddNotificationLettersByConfig
from DeleteDBA050 import DeleteDBA050
from AssignNotificationLetter import AssignNotificationLetter
from ReplaceDatabase import ReplaceDatabase
from JSONConfig import JSONConfigParser
from AddOneDoctor import AddOneDoctor
from AddDoctors import GoToUserManagementMenu, GoToPrompt

""" reset the database """
#ReplaceDatabase()
VistA=ConnectToVista('al_doc.log')

GoToUserManagementMenu(VistA)
# Primary Care Physician : GA PRIMARY CARE PROVIDER
AddOneDoctor(VistA,'STEWART,JANE','JS','000000030','0383166945','F','fakedoc2'  ,'2Doc!@#$','JSMI123','769',   'AL VA REGIONAL MEDICAL CENTER')
# Orthopedist            : GA ORTHOPEDIST PROVIDER
AddOneDoctor(VistA,'HANSON,MICHAEL','MH','000000039','9382539523','M','fakecar2'   ,'3Car!@#$','JOHM123','776',   'AL VA REGIONAL MEDICAL CENTER')
# Mental Health          : GA MENTAL HEALTH PROVIDER
AddOneDoctor(VistA,'SMITH,GEORGE','GS','000000051','0838136865','M','mhdoctor2'   ,'3Mhd!@#$','GEOK123','352',   'AL VA REGIONAL MEDICAL CENTER')
# Audiology (Ancilliary) : GA AUDIOLOGY ANCILLIARY
AddOneDoctor(VistA,'JACKSON,JOSEPH','JJ','000000052','0625639006','M','audidoctor2'   ,'2Aud!@#$','JOEK123','239',   'AL VA REGIONAL MEDICAL CENTER')
AddOneDoctor(VistA,'RANDOLPH,LORY','LR','000000053','0720312632','M','audidoctor3'   ,'2Aud!@#$','JOEK124','239',   'AL VA REGIONAL MEDICAL CENTER')